#ifndef WIRE_H
#define WIRE_H

#include "GlobalDefines.h"
#include "Gate_BASE.h"

#define SELECTION_WIDTH 10

class Gate_BASE;
class Canvas;

class Wire : public QGraphicsObject
{
    Q_OBJECT
    public:
        Wire(QGraphicsItem *parent = 0);
        ~Wire();

        QRectF boundingRect() const;
        QPainterPath shape() const;
        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

        void setPoints(Gate_BASE *source, Gate_BASE *sink, int sinkID);
        void setPenColor(QColor color);
        void setHighlight(bool state, QColor color);

        void setValue(logicValue value, logicValue faultyValue, bool recurse = true);

        Gate_BASE *gateOutput;
        Gate_BASE *gateInput;
        int gateInputID;

        logicValue wireValue;
        logicValue wireFaultyValue;

    signals:
        void updateStatus(QString status);

    public slots:
        void promptValue();
        void promptFaultyValue();
        void reset();
        void toggleShowValues();

    protected:
        virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);
        virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);

    private:
        void createActions();
        QAction *injectValueAction;
        QAction *injectFaultAction;
        QAction *resetValuesAction;

        QString valueString;

        bool auxSelected;
        bool showValues;

        QPen defaultPen;
        QBrush defaultBrush;

        QPen selectedPen;
        QPen highlightedPen;

        QFont defaultFont;
        QRectF textRect;

        QRectF bRect;
        QPainterPath shapeArea;
        QPainterPath line;
        QList<QPointF> linePoints;

#ifdef _DEBUG
        QPen debugPen;
        QBrush debugBrush;
        QPen debugSelectedPen;
        QPen debugErrorPen;
#endif
};

#endif // WIRE_H
